/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY                          *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public Liense as published by        *
 * the Free Software Foundation, either version 2 of the License, or (at      * 
 * your option) any later version.                                            *
 *                                                                            *
 * The ITX package is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
 * for more details.                                                          * 
 *                                                                            *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.                                                   *
 *                                                                            * 
 * Contact information:                                                       *
 * Donna Bergmark                                                             *
 * 484 Rhodes Hall                                                            *
 * Cornell University                                                         *
 * Ithaca, NY 14853-3801                                                      *
 * bergmark@cs.cornell.edu                                                    *
 ******************************************************************************/
package server;

import shared.*;
import cnrg.itx.datax.*;

/**
 * The <code>ServerPresentationControl</code> interface is an interface to 
 * an audio/visual slide presentation controller located on a SPOT server.
 * 
 * @author Jason Howes
 * @see cnrg.apps.spot.server.ServerException
 * @version 1.0, 3/16/1999
 */
public interface ServerPresentationControl
{	
	/**
	 * Various exception messages.
	 */
	public static final String NO_SUCH_TOPIC				= "No such topic found";
	public static final String PRESENTATION_IN_PROGRESS		= "Presentation in progress";
	public static final String PRESENTATION_NOT_IN_PROGRESS	= "Presentation not in progress";

	/**
	 * Starts the presentation.
	 * 
	 * @throws <code>ServerException</code> on error
	 */
	public void startPresentation() throws ServerException;
	
	/**
	 * Stops the slide presentation.
	 * 
	 * @throws <code>ServerException</code> on error.
	 */
	public void stopPresentation() throws ServerException;	
	
	/**
	 * Synchronizes the PPT presentation and audio with a given presentation slide.
	 */
	public void gotoPresentationSlide(int slide) throws ServerSessionException;
	
	/**
	 * Synchronizes the PPT presentation and audio with a specified presentation topic.
	 * 
	 * @param topic the desired topic with which to synchronize.
	 */	
	public void gotoPresentationTopic(String topic) throws ServerSessionException;

	/**
	 * Pauses the slide presentation.
	 */
	public void pausePresentation();

	/**
	 * Resumes a paused slide presentation.
	 */
	public void resumePresentation();
}
